function corrplot1(correlation,tags,title1,axis1)
%Custom-built function that creates the corelation plot given a correlation matrix
%
%Inputs:
%   correlation: correlation matrix
%   tags: alphanumeric explanation of the columns in the data set (should
%       not be left blank)
%   title1: a title for the figure (can be left blank)
%   axis1: the lable for the axis (can be left blank)
%
%Copyright 2014: Yuri Shardt
%Distributed as part of the book Statistics for Chemical and Process
%Engineers: A Modern Approach, published by Springer Verlag.


[a,b]=size(correlation);
imagesc(abs(correlation));colorbar;colormap(jet)
set(gca, 'XTick', 1:a); % center x-axis ticks on bins
set(gca, 'YTick', 1:a); % center y-axis ticks on bins
set(gca, 'XTickLabel', tags); % set x-axis labels
set(gca, 'YTickLabel', tags); % set y-axis labels
title(title1); % set title
xlabel(axis1);
ylabel(axis1);
